Attribute VB_Name = "mdOrientedPlane"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.



Function OrientedPlane(edge As aGeometric, angle, workplaneName As String, sketchName As String, bNoSketch As Boolean, color As Long)

'Convenience Function to create a workplane through a selected edge,angled to the active workplane

'check if the selected edge belongs to an EdgeClass
If edge Is Nothing Then
    MsgBox ("Edge is not Selected")
Else
    Dim blnEdge As Boolean
    blnEdge = edge.IsA("Geometric")
End If

If blnEdge Then
    
    'Get the ProDESKTOP Application object
    GetApplicationObject
    
    'Get the active part document
    Dim Part As PartDocument
    Set Part = app.GetActiveDoc
    
    'Get the design
    Dim Design As aDesign
    Set Design = Part.GetDesign()
    
    Dim geom As zGeometry
    Set geom = edge.GetGeometricForm
    
    Dim workplane As aWorkplane
    Set workplane = Part.GetActiveWorkplane
    
    Dim plane As zPlane
    Set plane = workplane.GetGeometry
        
    'Create a Parallel Plane
    Dim parallelPlane As zParallelPlane
    Set parallelPlane = app.GetClass("ParallelPlane").CreateParallelPlane(geom.Clone, plane.Clone, 1)
    
    'Create an Angled Plane
    Dim angledPlane As zAngledPlane
    Set angledPlane = app.GetClass("AngledPlane").CreateAngledPlane(geom, parallelPlane, angle, 1)

    'Check if a workplane with a same name exists
    
    Dim Found As Boolean
    Found = False
    
    Dim currentWorkplane As aWorkplane
    Set currentWorkplane = Part.LookupWorkplane(workplaneName)

    If Not currentWorkplane Is Nothing Then
        Found = True
    End If

    If Found Then
        MsgBox ("A workplane already exists with that name. Choose another name")
        Set OrientedPlane = Nothing
        GoTo 1000
    Else
    'Create the Oriented Workplane
        Set OrientedPlane = Design.CreateWorkplane(angledPlane, workplaneName)
    End If
        
    Dim identity As zMatrix
    Set identity = app.GetClass("Matrix").CreateScaleMatrix(1)
    Dim box As zBox
    Set box = angledPlane.GetBoundingBox(identity)
    
    Dim bIsEmpty As Boolean
    bIsEmpty = box.IsEmpty()
    
    If Not bIsEmpty Then
        OrientedPlane.SetLocalOrigin box.GetCenter
    End If
    
    'Create a sketch with the given sketch name
    If Not bNoSketch Then
    
        Dim OrientedPlaneSketch As aSketch
        Set OrientedPlaneSketch = OrientedPlane.CreateSketch(sketchName)
        Part.SetActiveSketch OrientedPlaneSketch
        
        'Set the color for the sketch
        If color < 0 Or color > 11 Then
            color = 4
        End If
        
        Dim colorCls As ColorClass
        Dim newColor As zColor
        Set colorCls = app.GetClass("Color")
        Set newColor = colorCls.CreateColor(1, color * 30, 0.35, 1)
        
        OrientedPlaneSketch.SetColor newColor
    
    End If
   
Else

    MsgBox ("Improper Selection of Entity")
    Set OrientedPlane = Nothing

End If


1000:
End Function
